// Autor: Ivan Katanic

#include <algorithm>
#include <cassert>
#include <cstring>
#include <iostream>
#include <vector>

using namespace std;

const int MAX = 2000;

bool done[MAX];
int ans[MAX];
int cnt0[MAX], id1[MAX];
vector<int> E[MAX];

void make_spicy(int i) {
  assert(id1[i] != -1);
  done[i] = true;
  if (ans[id1[i]]) return;
  
  ans[id1[i]] = 1;
  for (int j: E[id1[i]])
    if (--cnt0[j] == 0)
      if (!done[j]) make_spicy(j);
}

int main(void) {
  int n, m;
  scanf("%d %d", &n, &m);
  for (int i = 0; i < m; ++i) {
    int p;
    scanf("%d", &p);
    id1[i] = -1;
    for (int j = 0; j < p; ++j) {
      int u, v;
      scanf("%d %d", &u, &v); --u;
      if (v == 0) {
        cnt0[i]++;
        E[u].push_back(i);
      } else 
        id1[i] = u;
    }
  }

  for (int i = 0; i < m; ++i)
    if (cnt0[i] == 0 && !done[i]) make_spicy(i);

  for (int i = 0; i < n; ++i) {
    if (i) putchar(' ');
    printf("%d", ans[i]);
  }
  printf("\n");
  return 0;
}
